using System; 
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.OleDb;
using System.Data.SqlClient;

namespace DataReader_GetValues
{
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form
    {
        internal System.Windows.Forms.ListBox ListBox1;
        internal System.Windows.Forms.TextBox txtTitleWanted;
        internal System.Windows.Forms.Label Label1;
        internal System.Windows.Forms.Button btnFind;
        private System.Windows.Forms.Button btnFind2;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1()
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();

            //
            // TODO: Add any constructor code after InitializeComponent call
            //
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if (components != null) 
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

		#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.ListBox1 = new System.Windows.Forms.ListBox();
            this.txtTitleWanted = new System.Windows.Forms.TextBox();
            this.Label1 = new System.Windows.Forms.Label();
            this.btnFind = new System.Windows.Forms.Button();
            this.btnFind2 = new System.Windows.Forms.Button();
            this.SuspendLayout();
            // 
            // ListBox1
            // 
            this.ListBox1.Location = new System.Drawing.Point(8, 40);
            this.ListBox1.Name = "ListBox1";
            this.ListBox1.Size = new System.Drawing.Size(480, 238);
            this.ListBox1.TabIndex = 11;
            // 
            // txtTitleWanted
            // 
            this.txtTitleWanted.Location = new System.Drawing.Point(184, 8);
            this.txtTitleWanted.Name = "txtTitleWanted";
            this.txtTitleWanted.Size = new System.Drawing.Size(304, 20);
            this.txtTitleWanted.TabIndex = 9;
            this.txtTitleWanted.Text = "Hi%";
            // 
            // Label1
            // 
            this.Label1.Location = new System.Drawing.Point(0, 8);
            this.Label1.Name = "Label1";
            this.Label1.Size = new System.Drawing.Size(160, 24);
            this.Label1.TabIndex = 8;
            this.Label1.Text = "Title wanted (with %)";
            this.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // btnFind
            // 
            this.btnFind.Location = new System.Drawing.Point(8, 296);
            this.btnFind.Name = "btnFind";
            this.btnFind.Size = new System.Drawing.Size(112, 32);
            this.btnFind.TabIndex = 7;
            this.btnFind.Text = "Find Get<Type>()";
            this.btnFind.Click += new System.EventHandler(this.btnFind_Click);
            // 
            // btnFind2
            // 
            this.btnFind2.Location = new System.Drawing.Point(144, 296);
            this.btnFind2.Name = "btnFind2";
            this.btnFind2.Size = new System.Drawing.Size(112, 32);
            this.btnFind2.TabIndex = 12;
            this.btnFind2.Text = "Find  - GetValues()";
            this.btnFind2.Click += new System.EventHandler(this.btnFind2_Click);
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(496, 373);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.btnFind2,
                                                                          this.ListBox1,
                                                                          this.txtTitleWanted,
                                                                          this.Label1,
                                                                          this.btnFind});
            this.Name = "Form1";
            this.Text = "Form1";
            this.ResumeLayout(false);

        }
		#endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() 
        {
            Application.Run(new Form1());
        }

        private void btnFind_Click(object sender, System.EventArgs e)
        {
    
            try
            {   
				// Declare and Instantiate Connection and Selection Command Objects
                OleDbConnection cn = new OleDbConnection("Provider=SQLOLEDB.1;Integrated Security=SSPI;Initial Catalog=biblio;Data Source=.");
                OleDbCommand sc = new OleDbCommand("SELECT TOP 10 Title, Price FROM Titles WHERE title LIKE '" + txtTitleWanted.Text + "'", cn);
				// Declare a DataReader
                OleDbDataReader dr;

				// Open the Connection because a DataReader doesn't
				// automatically open a connection.
                cn.Open();
            
				// Instantiate a new DataReader by calling ExecuteReader()
				// on a Select Command object.
				// NOTE that we pass CommandBehaviour.CloseConnection to
				// the ExecuteReader() method - this will force the connection
				// closed when we close the DataReader.
                dr = sc.ExecuteReader(CommandBehavior.CloseConnection);
            
                // if our DataReader has rows then call ShowRows() and pass it our DataReader
				// if no rows then report to the Console output window.
				if (dr.FieldCount > 0)
                {
                    ShowRows(dr);
                }
                else
                {
                    Console.WriteLine("No rowset in this result set");
                }
				
				// Close the Data Reader
                dr.Close();

				// If you didn't belive me when I said the DataReader closed the connection
				// uncomment this line to report the state the Console  
                // Console.WriteLine(cn.State.ToString()); 
            }
            catch(Exception ex)
            {
                Debug.WriteLine(ex.ToString());
            }
        }
    
       
        
        private void ShowRowsGet(OleDbDataReader pDr )
        {
			try
			{
				// Declare and instantiate an object array with as many elements as their are fields in the DataReader
				object [] strData = new object [pDr.FieldCount];
            
				// Declare a string to hold values we build for output to our ListBox control
				string strValues;
				// Declare int to hold Number of objects returned by GetValues()
				int intObjectCount;

				// Clear the ListBox
				ListBox1.Items.Clear();                                                                                                  
                
                // Loop while the Reader still has data in it.                                                                                           
                while (pDr.Read())
                {
					// Populate the object array with GetValues() and set the
					// object Count variable. 
                    intObjectCount = pDr.GetValues(strData);

					// Clear the strValues field.
                    strValues = "";               
                    
                    // Loop for each Object                                                        
                    for(int intCol = 0; intCol <= intObjectCount - 1; intCol++)
                    {
						// Convert a DBNull field to a text value
                        if (Convert.IsDBNull(strData[intCol]))
                        {
                            strValues += " < null > ";
                        }
                        else
                        {
							// Build the output string.
                            strValues += strData[intCol].ToString() + "\t";
                        }
                        
                    }
					// Add the output string to the ListBox
                    ListBox1.Items.Add(strValues);
                }
            }
            catch ( Exception ex )
            {
                MessageBox.Show(ex.ToString());
            }
        }

        
        private void ShowRows(OleDbDataReader pDr )
        {
           try
            {
                // Declares a string to hold output data
                string strData;

               	// Clear the ListBox
                ListBox1.Items.Clear();
                
                // Loop while the Reader still has data in it.  
                while (pDr.Read())
                {
                    
                    // If the 2nd column contains Null output "UK
                    if (pDr.IsDBNull(1))
                    {
                        strData = "UK";
                    }
                    
                    // Build the output string With the Knowledge that Column 2 is a decimal
                    // and column 1 is a string
                    else
                    {
                        
                        strData = pDr.GetDecimal(1).ToString();
                    }                       
                    strData = strData + "\t" + pDr.GetString(0);

                    ListBox1.Items.Add(strData);
                }
               	
                // Add the output string to the ListBox
                if (ListBox1.Items.Count == 0)
                {
                    ListBox1.Items.Add("No data found!");
                }
            }
            catch (Exception ex)
            {
                Debug.WriteLine(ex.ToString());
            }
        }

        private void btnFind2_Click(object sender, System.EventArgs e)
        {
            try
            {
				// Declare and Instantiate Connection and Selection Command Objects
                OleDbConnection cn = new OleDbConnection("Provider=SQLOLEDB.1;Integrated Security=SSPI;Initial Catalog=biblio;Data Source=.");
                OleDbCommand sc = new OleDbCommand("SELECT TOP 10 Title, Price FROM Titles WHERE title LIKE '" + txtTitleWanted.Text + "'", cn);
                // Declare a DataReader
				OleDbDataReader dr;
				// Open the Connection because a DataReader doesn't
				// automatically open a connection.
                cn.Open();
            
				// Instantiate a new DataReader by calling ExecuteReader()
				// on a Select Command object.
				// NOTE that we pass CommandBehaviour.CloseConnection to
				// the ExecuteReader() method - this will force the connection
				// closed when we close the DataReader.
                dr = sc.ExecuteReader(CommandBehavior.CloseConnection);
            
				// if our DataReader has rows then call ShowRowsGet() and pass it our DataReader
				// if no rows then report to the Console output window.
                if (dr.FieldCount > 0)
                {
                    ShowRowsGet(dr);
                }
                else
                {
                    Console.WriteLine("No rowset in this result set");
                }

	            // Close the Data Reader
                dr.Close();

				// If you didn't belive me when I said the DataReader closed the connection
				// uncomment this line to report the connection state to the Console  
				// Console.WriteLine(cn.State.ToString()); 
	        }
            catch(Exception ex)
            {
                Debug.WriteLine(ex.ToString());
            }
        }
        }

    }

